<?php
/* --------------------------------------------------------------
   PaymentMatchingHubAdminMenuControl.inc.php 2018-08-14
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class PaymentMatchingHubAdminMenuControl
 *
 * Toggles the display of the payment matching menu item.
 */
class PaymentMatchingHubAdminMenuControl extends PaymentMatchingHubAdminMenuControl_parent
{
	/**
	 * @var string
	 */
	protected $configurationKey = 'GAMBIO_HUB_MECO_MEDIA_SHOP_ID';
	
	/**
	 * @var string
	 */
	protected $moneyOrderConfigurationKey = 'GAMBIO_HUB_MECO_MEDIA_MONEY_ORDER';
	
	/**
	 * @var string
	 */
	protected $invoiceConfigurationKey = 'GAMBIO_HUB_MECO_MEDIA_INVOICE';
	
	
	/**
	 * Replaces the payment methods link.
	 *
	 * It'll take care of the current version and reference the compatibility page if necessary.
	 *
	 * @param int $p_customers_id
	 *
	 * @return array
	 */
	public function get_menu_array($p_customers_id)
	{
		$menu_array = parent::get_menu_array($p_customers_id);
		
		if(class_exists(AdminAccessService::class))
		{
			$adminAccessService = StaticGXCoreLoader::getService('AdminAccess');
			
			if(!$adminAccessService->checkReadingPermissionForController(new NonEmptyStringType('PaymentMatchingHub'),
			                                                             new IdType((int)$_SESSION['customer_id'])))
			{
				return $menu_array;
			}
		}
		
		$connectedToHub = $this->_isConnectedToHub();
		
		$doesShopIdExist = $this->_doesShopIdExist();
		
		$areModulesActive = $this->_areModulesActive();
		
		// Remove the menu item if the the shop is not connected to Hub or the module is not installed/configured.
		foreach($menu_array as &$menu_block)
		{
			if(($connectedToHub === false || $doesShopIdExist === false || $areModulesActive === false)
			   && ($menu_block['id'] === 'BOX_HEADING_ORDERS' || $menu_block['id'] === 'BOX_HEADING_FAVORITES'))
			{
				foreach($menu_block['menuitems'] as $menu_block_idx => &$menu_item_hub)
				{
					if(strpos($menu_item_hub['link'], 'admin.php') !== false
					   && strpos($menu_item_hub['link_param'], 'do=PaymentMatchingHub') !== false)
					{
						unset($menu_block['menuitems'][$menu_block_idx]);
					}
				}
			}
		}
		
		return $menu_array;
	}
	
	
	/**
	 * Checks whether the shop is connector to hub.
	 *
	 * @return bool
	 */
	protected function _isConnectedToHub()
	{
		return gm_get_conf('GAMBIO_HUB_CLIENT_KEY') !== null
		       && gm_get_conf('GAMBIO_HUB_CLIENT_KEY') !== '';
	}
	
	
	/**
	 * Checks whether payment matching is installed and properly configured.
	 *
	 * @return bool
	 */
	protected function _doesShopIdExist()
	{
		return gm_get_conf($this->configurationKey) !== null && gm_get_conf($this->configurationKey) !== '';
	}
	
	
	/**
	 * Checks whether payment matching modules are active.
	 *
	 * @return bool
	 */
	protected function _areModulesActive()
	{
		return gm_get_conf($this->moneyOrderConfigurationKey) === 'True'
		       || gm_get_conf($this->invoiceConfigurationKey) === 'True';
	}
}
